/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.build.minimumbuilds;

import com.atlassian.bitbucket.hook.repository.DisableRepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.EnableRepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.GetRepositoryHookSettingsRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHook;
import com.atlassian.bitbucket.hook.repository.RepositoryHookService;
import com.atlassian.bitbucket.hook.repository.RepositoryHookSettings;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.setting.Settings;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import javax.annotation.Nonnull;
import org.springframework.stereotype.Component;

@Component
public class MinimumBuildsHelper {
    static final String PLUGIN_KEY = "com.atlassian.bitbucket.server.bitbucket-build";
    static final String REQUIRED_COUNT = "requiredCount";
    static final String MERGE_CHECK_KEY = "com.atlassian.bitbucket.server.bitbucket-build:requiredBuildsMergeCheck";
    private final RepositoryHookService repositoryHookService;
    private final EscalatedSecurityContext withRepoAdmin;

    public MinimumBuildsHelper(RepositoryHookService repositoryHookService, SecurityService securityService) {
        this.repositoryHookService = repositoryHookService;
        this.withRepoAdmin = securityService.withPermission(Permission.REPO_ADMIN, "Required builds hook");
    }

    void enable(RepositoryScope scope, int count) {
        Settings settings = this.repositoryHookService.createSettingsBuilder().add(REQUIRED_COUNT, count).build();
        EnableRepositoryHookRequest request = new EnableRepositoryHookRequest.Builder((Scope)scope, MERGE_CHECK_KEY).settings(settings).build();
        this.repositoryHookService.enable(request);
    }

    void disable(RepositoryScope scope) {
        DisableRepositoryHookRequest request = new DisableRepositoryHookRequest.Builder((Scope)scope, MERGE_CHECK_KEY).build();
        this.repositoryHookService.disable(request);
    }

    boolean isEnabled(RepositoryScope scope) {
        RepositoryHook repositoryHook = (RepositoryHook)this.withRepoAdmin.call(() -> this.repositoryHookService.getByKey((Scope)scope, MERGE_CHECK_KEY));
        return repositoryHook.isEnabled();
    }

    int getCount(@Nonnull RepositoryScope scope) {
        GetRepositoryHookSettingsRequest request = new GetRepositoryHookSettingsRequest.Builder((Scope)scope, MERGE_CHECK_KEY).build();
        RepositoryHookSettings hookSettings = (RepositoryHookSettings)this.withRepoAdmin.call(() -> this.repositoryHookService.getSettings(request));
        return hookSettings == null ? 0 : hookSettings.getSettings().getInt(REQUIRED_COUNT, 0);
    }

    int getCountDeprecated(@Nonnull Repository repository) {
        RepositoryScope scope = Scopes.repository((Repository)repository);
        if (this.isEnabled(scope)) {
            return this.getCount(scope);
        }
        return 0;
    }

    void saveCount(@Nonnull Repository repository, int count) {
        RepositoryScope scope = Scopes.repository((Repository)repository);
        if (count > 0) {
            this.enable(scope, count);
        } else {
            this.disable(scope);
        }
    }
}

