/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.branch.automerge;

import com.atlassian.bitbucket.audit.AuditEntry;
import com.atlassian.bitbucket.audit.AuditEntryBuilder;
import com.atlassian.bitbucket.audit.AuditEntryConverter;
import com.atlassian.bitbucket.branch.automerge.AutomaticMergeEvent;
import com.atlassian.bitbucket.branch.automerge.AutomaticMergeStoppedEvent;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.AuditUtils;
import com.atlassian.bitbucket.util.MoreStreams;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class AutomaticMergeEventConverter
implements AuditEntryConverter<AutomaticMergeEvent> {
    private static Function<RefChange, Map<String, Object>> REF_CHANGE_TO_MAP = change -> ImmutableMap.of((Object)"ref", (Object)change.getRef().getId(), (Object)"from", (Object)change.getFromHash(), (Object)"to", (Object)change.getToHash());

    @Nonnull
    public AuditEntry convert(@Nonnull AutomaticMergeEvent event, AuditEntryBuilder builder) {
        List refChanges = event.getRefChanges().stream().map(REF_CHANGE_TO_MAP).collect(Collectors.toList());
        List mergePaths = MoreStreams.streamIterable(event.getMergePath()).map(MinimalRef::getId).collect(Collectors.toList());
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder().put((Object)"refChanges", refChanges).put((Object)"mergePath", mergePaths);
        if (event instanceof AutomaticMergeStoppedEvent) {
            AutomaticMergeStoppedEvent stoppedEvent = (AutomaticMergeStoppedEvent)event;
            mapBuilder.put((Object)"reason", (Object)stoppedEvent.getReason());
        }
        return builder.action(((Object)((Object)event)).getClass()).timestamp(new Date()).details(AuditUtils.toJson((Object)mapBuilder.build())).user(event.getUser()).target(AuditUtils.toProjectAndRepositoryString((Repository)event.getRepository())).repository(event.getRepository()).build();
    }
}

