/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.user;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionRequest;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class UserSearchRequest {
    private final String filter;
    private final String group;
    private final Set<PermissionRequest> permissions;

    private UserSearchRequest(Builder builder) {
        this.filter = builder.filter;
        this.group = builder.group;
        this.permissions = ImmutableSet.copyOf(builder.permissions);
    }

    @Nullable
    public String getFilter() {
        return this.filter;
    }

    @Nullable
    public String getGroup() {
        return this.group;
    }

    @Nonnull
    public Set<PermissionRequest> getPermissions() {
        return this.permissions;
    }

    public static class Builder {
        private String filter;
        private String group;
        private final Set<PermissionRequest> permissions = new HashSet<PermissionRequest>();

        public Builder() {
        }

        public Builder(@Nonnull UserSearchRequest request) {
            this.filter = request.filter;
            this.group = request.group;
            this.permissions.addAll(request.getPermissions());
        }

        @Nonnull
        public UserSearchRequest build() {
            return new UserSearchRequest(this);
        }

        @Nonnull
        public Builder filter(@Nullable String filter) {
            this.filter = StringUtils.trimToNull((String)filter);
            return this;
        }

        @Nonnull
        public Builder group(@Nullable String group) {
            this.group = StringUtils.trimToNull((String)group);
            return this;
        }

        @Nonnull
        public Builder permission(@Nonnull Permission permission) {
            this.permissions.add(new PermissionRequest.Builder(permission).build());
            return this;
        }

        @Nonnull
        public Builder projectPermission(@Nonnull Project project, @Nonnull Permission permission) {
            Objects.requireNonNull(project, "project");
            this.permissions.add(new PermissionRequest.Builder(permission).resource(project).build());
            return this;
        }

        @Nonnull
        public Builder projectPermission(int projectId, @Nonnull Permission permission) {
            this.permissions.add(new PermissionRequest.Builder(permission).resource(projectId).build());
            return this;
        }

        @Nonnull
        public Builder repositoryPermission(@Nonnull Repository repository, @Nonnull Permission permission) {
            Objects.requireNonNull(repository, "repository");
            this.permissions.add(new PermissionRequest.Builder(permission).resource(repository).build());
            return this;
        }

        @Nonnull
        public Builder repositoryPermission(int repositoryId, @Nonnull Permission permission) {
            this.permissions.add(new PermissionRequest.Builder(permission).resource(repositoryId).build());
            return this;
        }
    }
}

