/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.commit.AbstractCommitRequest;
import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class AbstractCommitCommandParameters
extends AbstractCommandParameters {
    private final String commitId;
    private final String path;

    protected AbstractCommitCommandParameters(AbstractCommitParametersBuilder<?> builder) {
        this.commitId = builder.commitId;
        this.path = builder.path;
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    public boolean hasPath() {
        return StringUtils.isNotBlank((CharSequence)this.path);
    }

    public static abstract class AbstractCommitParametersBuilder<B extends AbstractCommitParametersBuilder<B>> {
        private String commitId;
        private String path;

        protected AbstractCommitParametersBuilder() {
        }

        protected AbstractCommitParametersBuilder(@Nonnull AbstractCommitRequest request) {
            this.commitId = Objects.requireNonNull(request, "request").getCommitId();
            this.path = request.getPath();
        }

        @Nonnull
        public B commitId(String value) {
            this.commitId = value;
            return this.self();
        }

        @Nonnull
        public B path(String value) {
            this.path = value;
            return this.self();
        }

        @Nonnull
        protected abstract B self();
    }
}

