/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.project.NoSuchProjectException;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryCloneLinksRequest;
import com.atlassian.bitbucket.repository.RepositoryCreateRequest;
import com.atlassian.bitbucket.repository.RepositoryForkRequest;
import com.atlassian.bitbucket.repository.RepositorySearchRequest;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.repository.RepositoryUpdateRequest;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.NamedLink;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface RepositoryService
extends RepositorySupplier {
    public int countByProject(@Nonnull Project var1);

    @Nonnull
    public Repository create(@Nonnull RepositoryCreateRequest var1);

    public void delete(@Nonnull Repository var1);

    @Nonnull
    public Page<Repository> findAll(@Nonnull PageRequest var1);

    @Nonnull
    public Page<Repository> findByOrigin(@Nonnull Repository var1, @Nonnull PageRequest var2);

    @Nonnull
    public Page<Repository> findByOwner(@Nonnull ApplicationUser var1, @Nonnull PageRequest var2);

    @Nonnull
    public Page<Repository> findByProjectId(int var1, @Nonnull PageRequest var2) throws NoSuchProjectException;

    @Nonnull
    public Page<Repository> findByProjectKey(@Nonnull String var1, @Nonnull PageRequest var2) throws NoSuchProjectException;

    @Nullable
    public Repository findPersonalFork(@Nonnull Repository var1);

    @Nonnull
    public Page<Repository> findRelated(@Nonnull Repository var1, @Nonnull PageRequest var2);

    @Nonnull
    public Repository fork(@Nonnull RepositoryForkRequest var1);

    @Override
    @Nullable
    public Repository getById(int var1);

    @Override
    @Nullable
    public Repository getBySlug(@Nonnull String var1, @Nonnull String var2);

    @Nonnull
    public Set<NamedLink> getCloneLinks(@Nonnull RepositoryCloneLinksRequest var1);

    @Nullable
    public String getDefaultBranch();

    @Nonnull
    public MinimalRef getDefaultBranch(@Nonnull Repository var1);

    public long getSize(@Nonnull Repository var1);

    public boolean isEmpty(@Nonnull Repository var1);

    public boolean isForkingEnabled();

    @Nonnull
    public Repository retryCreate(@Nonnull Repository var1);

    @Nonnull
    public Page<Repository> search(@Nonnull RepositorySearchRequest var1, @Nonnull PageRequest var2);

    public void setDefaultBranch(@Nullable String var1);

    @Nonnull
    public Repository setReadOnly(@Nonnull Repository var1, boolean var2);

    @Nonnull
    public Repository update(@Nonnull RepositoryUpdateRequest var1);
}

