/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.filestore;

import com.atlassian.bitbucket.filestore.FilePath;
import com.atlassian.bitbucket.util.BuilderSupport;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ReadFileRequest {
    private final String namespace;
    private final FilePath path;

    private ReadFileRequest(@Nonnull Builder builder) {
        this.namespace = builder.namespace;
        this.path = builder.path;
    }

    @Nullable
    public String getNamespace() {
        return this.namespace;
    }

    @Nullable
    public FilePath getPath() {
        return this.path;
    }

    public static class Builder
    extends BuilderSupport {
        private String namespace;
        private FilePath path;

        @Nonnull
        public ReadFileRequest build() {
            return new ReadFileRequest(this);
        }

        @Nonnull
        public Builder namespace(String value) {
            this.namespace = Builder.requireNonBlank(value, "namespace");
            return this;
        }

        @Nonnull
        public Builder path(@Nonnull FilePath value) {
            this.path = Objects.requireNonNull(value, "path");
            return this;
        }
    }
}

