/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.content.DiffContentFilter;
import com.atlassian.bitbucket.content.DiffWhitespace;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractDiffRequest {
    public static final int DEFAULT_CONTEXT_LINES = -1;
    private final int contextLines;
    private final DiffContentFilter filter;
    private final Set<String> paths;
    private final DiffWhitespace whitespace;

    protected AbstractDiffRequest(AbstractBuilder<?, ?> builder) {
        this.contextLines = builder.contextLines;
        this.filter = builder.filter;
        this.paths = builder.paths.build();
        this.whitespace = builder.whitespace;
    }

    public int getContextLines() {
        return this.contextLines;
    }

    @Nullable
    public DiffContentFilter getFilter() {
        return this.filter;
    }

    @Nonnull
    public Set<String> getPaths() {
        return this.paths;
    }

    @Nonnull
    public DiffWhitespace getWhitespace() {
        return this.whitespace;
    }

    public boolean hasContextLines() {
        return this.contextLines > -1;
    }

    protected static abstract class AbstractBuilder<B extends AbstractBuilder<B, R>, R>
    extends BuilderSupport {
        private final ImmutableSet.Builder<String> paths = ImmutableSet.builder();
        private int contextLines;
        private DiffContentFilter filter;
        private DiffWhitespace whitespace;

        protected AbstractBuilder() {
            this.contextLines = -1;
            this.whitespace = DiffWhitespace.SHOW;
        }

        protected AbstractBuilder(@Nonnull AbstractDiffRequest request) {
            this.contextLines = Objects.requireNonNull(request, "request").getContextLines();
            this.whitespace = Objects.requireNonNull(request.getWhitespace(), "request.whitespace");
            AbstractBuilder.addIf(NOT_BLANK, this.paths, request.getPaths());
        }

        @Nonnull
        public abstract R build();

        @Nonnull
        public B contextLines(int value) {
            this.contextLines = Math.max(-1, value);
            return this.self();
        }

        @Nonnull
        public B filter(@Nullable DiffContentFilter value) {
            this.filter = value;
            return this.self();
        }

        @Nonnull
        public B path(@Nullable String value) {
            AbstractBuilder.addIf(NOT_BLANK, this.paths, value);
            return this.self();
        }

        @Nonnull
        public B paths(@Nullable Iterable<String> values) {
            AbstractBuilder.addIf(NOT_BLANK, this.paths, values);
            return this.self();
        }

        @Nonnull
        public B paths(@Nullable String value, String ... values) {
            AbstractBuilder.addIf(NOT_BLANK, this.paths, value, values);
            return this.self();
        }

        @Nonnull
        public B whitespace(@Nonnull DiffWhitespace value) {
            this.whitespace = Objects.requireNonNull(value, "value");
            return this.self();
        }

        @Nonnull
        protected abstract B self();
    }
}

