/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.build.status;

import com.atlassian.bitbucket.build.BuildOrder;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractBuildStatusSearchRequest {
    private final BuildOrder buildOrder;
    private final String commitId;
    private final String key;
    private final Repository repository;

    protected AbstractBuildStatusSearchRequest(@Nonnull AbstractBuilder<?> builder) {
        this.buildOrder = (BuildOrder)((Object)MoreObjects.firstNonNull((Object)((Object)builder.buildOrder), (Object)((Object)BuildOrder.NEWEST)));
        this.commitId = builder.commitId;
        this.key = builder.key;
        this.repository = builder.repository;
    }

    @Nonnull
    public BuildOrder getBuildOrder() {
        return this.buildOrder;
    }

    @Nullable
    public String getCommitId() {
        return this.commitId;
    }

    @Nullable
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public static abstract class AbstractBuilder<T extends AbstractBuilder<T>>
    extends BuilderSupport {
        private final Repository repository;
        private BuildOrder buildOrder;
        private String commitId;
        private String key;

        public AbstractBuilder(@Nonnull Repository repository) {
            this.repository = Objects.requireNonNull(repository, "repository");
        }

        public AbstractBuilder(@Nonnull AbstractBuildStatusSearchRequest request) {
            Objects.requireNonNull(request);
            this.commitId = request.getCommitId();
            this.repository = request.getRepository();
            this.buildOrder = request.getBuildOrder();
            this.key = request.getKey();
        }

        public abstract AbstractBuildStatusSearchRequest build();

        @Nonnull
        public T buildOrder(@Nonnull BuildOrder buildOrder) {
            this.buildOrder = buildOrder;
            return this.self();
        }

        @Nonnull
        public T commitId(@Nullable String commitId) {
            this.commitId = StringUtils.stripToNull((String)commitId);
            return this.self();
        }

        @Nonnull
        public T key(@Nullable String key) {
            this.key = StringUtils.trimToNull((String)key);
            return this.self();
        }

        @Nonnull
        public abstract T self();
    }
}

