/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.filestore;

import com.atlassian.bitbucket.util.BuilderSupport;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class GeneratePutUrlResponse {
    private final Map<String, List<String>> headers;
    private final URL url;

    private GeneratePutUrlResponse(@Nonnull Builder builder) {
        this.headers = builder.headers;
        this.url = builder.url;
    }

    @Nonnull
    public Map<String, List<String>> getHeaders() {
        return Map.copyOf(this.headers);
    }

    @Nonnull
    public URL getUrl() {
        return this.url;
    }

    public static class Builder
    extends BuilderSupport {
        private final Map<String, List<String>> headers;
        private final URL url;

        public Builder(@Nonnull URL url) {
            this.url = url;
            this.headers = new LinkedHashMap<String, List<String>>();
        }

        @Nonnull
        public GeneratePutUrlResponse build() {
            return new GeneratePutUrlResponse(this);
        }

        @Nonnull
        public Builder header(String key, List<String> values) {
            this.headers.put(key, values);
            return this;
        }

        @Nonnull
        public Builder header(Map<String, List<String>> values) {
            this.headers.putAll(values);
            return this;
        }
    }
}

