/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.filestore;

import com.atlassian.bitbucket.util.BuilderSupport;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class GenerateGetUrlResponse {
    private final Map<String, List<String>> headers;
    private final URL url;

    private GenerateGetUrlResponse(@Nonnull Builder builder) {
        this.headers = builder.headers;
        this.url = builder.url;
    }

    @Nonnull
    public Map<String, List<String>> getHeaders() {
        return Map.copyOf(this.headers);
    }

    @Nonnull
    public URL getUrl() {
        return this.url;
    }

    public static class Builder
    extends BuilderSupport {
        private final Map<String, List<String>> headers;
        private final URL url;

        public Builder(@Nonnull URL url) {
            this.url = url;
            this.headers = new LinkedHashMap<String, List<String>>();
        }

        @Nonnull
        public GenerateGetUrlResponse build() {
            return new GenerateGetUrlResponse(this);
        }

        @Nonnull
        public Builder header(@Nonnull String key, @Nonnull List<String> values) {
            Objects.requireNonNull(values, "header");
            this.headers.put(key, values);
            return this;
        }

        @Nonnull
        public Builder header(@Nonnull Map<String, List<String>> values) {
            Objects.requireNonNull(values, "header");
            this.headers.putAll(values);
            return this;
        }
    }
}

