/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.filestore;

import java.util.Objects;
import javax.annotation.Nonnull;

public class FilePath {
    private final String path;

    public FilePath(@Nonnull String path) {
        Objects.requireNonNull(path, "path");
        if (path.contains("..")) {
            throw new IllegalArgumentException("Path cannot contain '..'");
        }
        if (path.startsWith("/")) {
            throw new IllegalArgumentException("Path cannot start with '/'");
        }
        if (path.endsWith(".")) {
            throw new IllegalArgumentException("Path cannot end with '.'");
        }
        if (path.endsWith(" ")) {
            throw new IllegalArgumentException("Path cannot end with space");
        }
        for (char c : path.toCharArray()) {
            if (FilePath.isValidCharacter(c)) continue;
            throw new IllegalArgumentException("Invalid character in path: " + c);
        }
        this.path = path;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FilePath other = (FilePath)obj;
        return Objects.equals(this.path, other.path);
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    public int hashCode() {
        return Objects.hashCode(this.path);
    }

    public String toString() {
        return this.path;
    }

    private static boolean isValidCharacter(char c) {
        if (c < ' ' || c > '~') {
            return false;
        }
        return switch (c) {
            case '\"', '(', ')', '*', ':', ';', '<', '>', '?', '\\', '|' -> false;
            default -> true;
        };
    }
}

