/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class Version
implements Comparable<Version> {
    public static final Pattern STRICT_NUMERIC_VALIDATOR = Pattern.compile("^\\d+(\\.\\d+)*$");
    private static final Pattern STARTS_NUMERICAL_PATTERN = Pattern.compile("^(\\d+).*");
    private final List<Integer> version;
    private final String versionString;

    public Version(Integer ... elements) {
        ArrayList<Integer> list = new ArrayList<Integer>(elements.length);
        Collections.addAll(list, elements);
        this.version = Version.normalize(list);
        this.versionString = StringUtils.join(this.version, (String)".");
    }

    public Version(String version) {
        String[] components = version.split("[.\\-]");
        ArrayList<Integer> list = new ArrayList<Integer>(components.length);
        for (String component : components) {
            try {
                list.add(Integer.valueOf(component));
            }
            catch (NumberFormatException e) {
                Matcher matcher = STARTS_NUMERICAL_PATTERN.matcher(component);
                if (!matcher.matches()) break;
                list.add(Integer.valueOf(matcher.group(1)));
                break;
            }
        }
        this.version = Version.normalize(list);
        this.versionString = StringUtils.join(this.version, (String)".");
    }

    @Override
    public int compareTo(@Nonnull Version o) {
        int mySize = this.version.size();
        int theirSize = o.version.size();
        int maxSize = Math.max(theirSize, mySize);
        for (int i = 0; i < maxSize; ++i) {
            int theirs;
            int mine = i < mySize ? this.version.get(i) : 0;
            int diff = mine - (theirs = i < theirSize ? o.version.get(i) : 0);
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        return this.versionString.equals(other.versionString);
    }

    public int getMajor() {
        return this.version.get(0);
    }

    public int getMinor() {
        return this.version.get(1);
    }

    public int getPatch() {
        return this.version.get(2);
    }

    @Nonnull
    public List<Integer> getVersion() {
        return this.version;
    }

    public int hashCode() {
        return this.versionString.hashCode();
    }

    public String toString() {
        return this.versionString;
    }

    private static List<Integer> normalize(List<Integer> list) {
        while (list.size() < 3) {
            list.add(0);
        }
        return ImmutableList.copyOf(list);
    }
}

