/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.bulk;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BulkContentContext {
    private final String sinceCommitId;
    private final String untilCommitId;

    private BulkContentContext(Builder builder) {
        this.sinceCommitId = builder.sinceCommitId;
        this.untilCommitId = builder.untilCommitId;
    }

    @Nonnull
    public Optional<String> getSinceCommitId() {
        return Optional.ofNullable(this.sinceCommitId);
    }

    @Nonnull
    public String getUntilCommitId() {
        return this.untilCommitId;
    }

    public static class Builder {
        private final String untilCommitId;
        private String sinceCommitId;

        public Builder(@Nonnull String untilCommitId) {
            this.untilCommitId = Objects.requireNonNull(untilCommitId, "untilCommitId");
        }

        @Nonnull
        public Builder sinceCommitId(@Nullable String value) {
            this.sinceCommitId = value;
            return this;
        }

        @Nonnull
        public BulkContentContext build() {
            return new BulkContentContext(this);
        }
    }
}

