/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.comment;

import com.atlassian.bitbucket.comment.CommentSeverity;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AddCommentReplyRequest {
    private final long parentId;
    private boolean pending;
    private final CommentSeverity severity;
    private final String text;

    private AddCommentReplyRequest(@Nonnull Builder builder) {
        this.parentId = builder.parentId;
        this.pending = builder.pending;
        this.severity = builder.severity;
        this.text = builder.text;
    }

    public long getParentId() {
        return this.parentId;
    }

    @Nullable
    public CommentSeverity getSeverity() {
        return this.severity;
    }

    @Nonnull
    public String getText() {
        return this.text;
    }

    public boolean isPending() {
        return this.pending;
    }

    public static class Builder {
        private final long parentId;
        private final String text;
        private boolean pending;
        private CommentSeverity severity;

        public Builder(long parentId, @Nonnull String text) {
            this.parentId = parentId;
            this.text = Objects.requireNonNull(text, "text");
        }

        @Nonnull
        public AddCommentReplyRequest build() {
            return new AddCommentReplyRequest(this);
        }

        @Nonnull
        public Builder pending(boolean value) {
            this.pending = value;
            return this;
        }

        @Nonnull
        public Builder severity(@Nullable CommentSeverity value) {
            this.severity = value;
            return this;
        }
    }
}

