/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.bulk;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BulkTraverseCommitsCommandParameters
extends AbstractCommandParameters {
    private final boolean ignoreMissing;
    private final Set<String> includes;
    private final Set<Repository> alternates;

    private BulkTraverseCommitsCommandParameters(Builder builder) {
        this.ignoreMissing = builder.ignoreMissing;
        this.includes = builder.includes.build();
        this.alternates = builder.alternates.build();
        if (this.includes.isEmpty()) {
            throw new IllegalStateException("The parameters must include commits to traverse.");
        }
    }

    @Nonnull
    public Set<Repository> getAlternates() {
        return this.alternates;
    }

    @Nonnull
    public Set<String> getIncludes() {
        return this.includes;
    }

    public boolean isIgnoringMissing() {
        return this.ignoreMissing;
    }

    public static class Builder {
        private final ImmutableSet.Builder<Repository> alternates = ImmutableSet.builder();
        private final ImmutableSet.Builder<String> includes = ImmutableSet.builder();
        private boolean ignoreMissing;

        @Nonnull
        public BulkTraverseCommitsCommandParameters build() {
            return new BulkTraverseCommitsCommandParameters(this);
        }

        @Nonnull
        public Builder alternate(@Nullable Repository value) {
            if (value != null) {
                this.alternates.add((Object)value);
            }
            return this;
        }

        @Nonnull
        public Builder alternates(@Nullable Iterable<Repository> values) {
            BulkTraverseCommitsCommandParameters.addIf(Objects::nonNull, this.alternates, values);
            return this;
        }

        @Nonnull
        public Builder alternates(@Nullable Repository value, Repository ... values) {
            BulkTraverseCommitsCommandParameters.addIf(Objects::nonNull, this.alternates, value, values);
            return this;
        }

        @Nonnull
        public Builder ignoreMissing(boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        @Nonnull
        public Builder include(@Nullable Iterable<String> values) {
            BulkTraverseCommitsCommandParameters.addIf(NOT_BLANK, this.includes, values);
            return this;
        }

        @Nonnull
        public Builder include(@Nullable String value, String ... values) {
            BulkTraverseCommitsCommandParameters.addIf(NOT_BLANK, this.includes, value, values);
            return this;
        }
    }
}

