/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.permission;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class SetPermissionRequest {
    private final Permission permission;
    private final Set<ApplicationUser> users;
    private final Set<String> groups;
    private final Project project;
    private final Repository repository;

    private SetPermissionRequest(@Nonnull Permission permission, @Nonnull Set<ApplicationUser> users, @Nonnull Set<String> groups, @Nullable Project project, @Nullable Repository repository) {
        Preconditions.checkArgument((!permission.isGlobal() || project == null && repository == null ? 1 : 0) != 0, (Object)"global permissions can not be granted to projects or repositories");
        Preconditions.checkArgument((!permission.isResource(Project.class) || project != null ? 1 : 0) != 0, (Object)"project permissions can not be granted to a null project");
        Preconditions.checkArgument((!permission.isResource(Repository.class) || repository != null ? 1 : 0) != 0, (Object)"repository permissions can not be granted to a null repository");
        Preconditions.checkArgument((!permission.isResource(Project.class) || repository == null ? 1 : 0) != 0, (Object)"project permissions can not be granted to a repository");
        Preconditions.checkArgument((!permission.isResource(Repository.class) || project == null ? 1 : 0) != 0, (Object)"repository permissions can not be granted to a project");
        Preconditions.checkArgument((!users.isEmpty() || !groups.isEmpty() ? 1 : 0) != 0, (Object)"either a user or a group must be specified");
        this.permission = permission;
        this.groups = groups;
        this.users = users;
        this.project = project;
        this.repository = repository;
    }

    @Nonnull
    public Permission getPermission() {
        return this.permission;
    }

    @Nonnull
    public Set<ApplicationUser> getUsers() {
        return this.users;
    }

    @Nonnull
    public Set<String> getGroups() {
        return this.groups;
    }

    public Project getProject() {
        return this.project;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.permission, this.users, this.groups, this.project, this.repository});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SetPermissionRequest other = (SetPermissionRequest)obj;
        return Objects.equals((Object)this.permission, (Object)other.permission) && Objects.equals(this.users, other.users) && Objects.equals(this.groups, other.groups) && Objects.equals(this.project, other.project) && Objects.equals(this.repository, other.repository);
    }

    public static class Builder
    extends BuilderSupport {
        private Permission permission;
        private Set<ApplicationUser> users;
        private Set<String> groups;
        private Project project;
        private Repository repository;

        public Builder globalPermission(@Nonnull Permission permission) {
            Preconditions.checkArgument((boolean)permission.isGlobal(), (Object)"not a global permission");
            this.permission = permission;
            return this;
        }

        public Builder projectPermission(@Nonnull Permission permission, @Nonnull Project project) {
            Preconditions.checkArgument((boolean)permission.isResource(Project.class), (Object)"not a project permission");
            this.permission = permission;
            this.project = Objects.requireNonNull(project, "project");
            return this;
        }

        public Builder repositoryPermission(@Nonnull Permission permission, @Nonnull Repository repository) {
            Preconditions.checkArgument((boolean)permission.isResource(Repository.class), (Object)"not a repository permission");
            this.permission = permission;
            this.repository = Objects.requireNonNull(repository, "repository");
            return this;
        }

        public Builder user(@Nonnull ApplicationUser user) {
            this.users = ImmutableSet.of((Object)Objects.requireNonNull(user, "user"));
            return this;
        }

        public Builder users(@Nonnull Iterable<ApplicationUser> users) {
            Preconditions.checkArgument((boolean)Iterables.all(users, Objects::nonNull), (Object)"can not have null users");
            this.users = ImmutableSet.copyOf(users);
            return this;
        }

        public Builder group(@Nonnull String group) {
            Builder.checkNotBlank(group, "group");
            this.groups = ImmutableSet.of((Object)group);
            return this;
        }

        public Builder groups(@Nonnull Iterable<String> groups) {
            Preconditions.checkArgument((boolean)Iterables.all(groups, StringUtils::isNotEmpty), (Object)"can not have null or empty groups");
            this.groups = ImmutableSet.copyOf(groups);
            return this;
        }

        public SetPermissionRequest build() {
            Object users = this.users == null ? ImmutableSet.of() : this.users;
            Object groups = this.groups == null ? ImmutableSet.of() : this.groups;
            return new SetPermissionRequest(this.permission, (Set<ApplicationUser>)users, (Set<String>)groups, this.project, this.repository);
        }
    }
}

