/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.pull.AbstractPullRequestRequest;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PullRequestParticipantStatusRequest
extends AbstractPullRequestRequest {
    private final String lastReviewedCommit;
    private final PullRequestParticipantStatus status;
    private final int version;

    private PullRequestParticipantStatusRequest(Builder builder) {
        super(builder);
        this.lastReviewedCommit = builder.lastReviewedCommit;
        this.status = Objects.requireNonNull(builder.status, "status");
        this.version = builder.version;
    }

    @Nullable
    public String getLastReviewedCommit() {
        return this.lastReviewedCommit;
    }

    @Nonnull
    public PullRequestParticipantStatus getStatus() {
        return this.status;
    }

    @Deprecated
    public int getVersion() {
        return this.version;
    }

    public static class Builder
    extends AbstractPullRequestRequest.AbstractBuilder<Builder> {
        private String lastReviewedCommit;
        private PullRequestParticipantStatus status;
        private int version;

        public Builder(@Nonnull PullRequest pullRequest) {
            super(pullRequest);
        }

        public Builder(int repositoryId, long pullRequestId) {
            super(repositoryId, pullRequestId);
        }

        @Nonnull
        public PullRequestParticipantStatusRequest build() {
            return new PullRequestParticipantStatusRequest(this);
        }

        @Nonnull
        public Builder lastReviewedCommit(@Nullable String value) {
            this.lastReviewedCommit = value;
            return this.self();
        }

        @Nonnull
        public Builder status(@Nonnull PullRequestParticipantStatus value) {
            this.status = Objects.requireNonNull(value, "status");
            return this.self();
        }

        @Deprecated
        @Nonnull
        public Builder version(int value) {
            this.version = value;
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

