/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.event.repository;

import com.atlassian.bitbucket.event.CancelableEvent;
import com.atlassian.bitbucket.event.repository.RepositoryEvent;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.CancelState;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class RepositoryDeletionRequestedEvent
extends RepositoryEvent
implements CancelableEvent {
    private final CancelState cancelState;
    private final Set<Integer> forkIds;

    public RepositoryDeletionRequestedEvent(@Nonnull Object source, @Nonnull Repository repository, @Nonnull CancelState cancelState, @Nonnull Iterable<Integer> forkIds) {
        super(source, repository);
        this.cancelState = Objects.requireNonNull(cancelState, "cancelState");
        this.forkIds = ImmutableSet.copyOf(Objects.requireNonNull(forkIds, "forkIds"));
    }

    @Override
    public void cancel(@Nonnull KeyedMessage message) {
        this.cancelState.cancel(message);
    }

    @Override
    public boolean isCanceled() {
        return this.cancelState.isCanceled();
    }

    @Nonnull
    public Set<Integer> getForkIds() {
        return this.forkIds;
    }
}

