/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class AbstractMergeCommandParameters
extends AbstractCommandParameters {
    private final ApplicationUser author;
    private final int commitSummaries;
    private final ApplicationUser committer;
    private final boolean dryRun;
    private final String message;
    private final String strategyId;

    protected AbstractMergeCommandParameters(AbstractBuilder<?> builder) {
        this.author = Objects.requireNonNull(builder.author == null ? builder.committer : builder.author, "author");
        this.commitSummaries = Math.max(builder.commitSummaries, 0);
        this.committer = (ApplicationUser)MoreObjects.firstNonNull((Object)builder.committer, (Object)builder.author);
        this.dryRun = builder.dryRun;
        this.message = builder.message;
        this.strategyId = builder.strategyId;
    }

    @Nonnull
    public ApplicationUser getAuthor() {
        return this.author;
    }

    public int getCommitSummaries() {
        return this.commitSummaries;
    }

    @Nonnull
    public ApplicationUser getCommitter() {
        return this.committer;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Nullable
    public String getStrategyId() {
        return this.strategyId;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B>> {
        private ApplicationUser author;
        private int commitSummaries = 20;
        private ApplicationUser committer;
        private boolean dryRun;
        private String message;
        private String strategyId;

        @Nonnull
        public B author(@Nonnull ApplicationUser value) {
            this.author = Objects.requireNonNull(value, "author");
            return this.self();
        }

        @Nonnull
        public B commitSummaries(int value) {
            this.commitSummaries = value;
            return this.self();
        }

        @Nonnull
        public B committer(@Nonnull ApplicationUser value) {
            this.committer = Objects.requireNonNull(value, "author");
            return this.self();
        }

        @Nonnull
        public B dryRun(boolean value) {
            this.dryRun = value;
            return this.self();
        }

        @Nonnull
        public B message(@Nullable String value) {
            this.message = value;
            return this.self();
        }

        @Nonnull
        public B strategyId(@Nullable String value) {
            this.strategyId = value;
            return this.self();
        }

        @Nonnull
        protected abstract B self();

        protected void validate() {
            if (this.author == null) {
                throw new IllegalStateException("When performing or testing a merge, an author is required");
            }
            if (StringUtils.isBlank((CharSequence)this.author.getDisplayName())) {
                throw new IllegalStateException("When performing a merge, the author must have a display name");
            }
            if (StringUtils.isBlank((CharSequence)this.author.getEmailAddress())) {
                throw new IllegalStateException("When performing a merge, the author must have an e-mail address");
            }
            if (!this.dryRun && StringUtils.isEmpty((CharSequence)this.message)) {
                throw new IllegalStateException("When performing a merge, a commit message is required");
            }
        }
    }
}

