/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.content.DiffWhitespace;
import com.atlassian.bitbucket.pull.AbstractPullRequestRequest;
import com.atlassian.bitbucket.pull.PullRequest;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class PullRequestDiffStatsSummaryRequest
extends AbstractPullRequestRequest {
    private final String path;
    private final String sinceId;
    private final String srcPath;
    private final String untilId;
    private final DiffWhitespace whitespace;

    private PullRequestDiffStatsSummaryRequest(@Nonnull Builder builder) {
        super(builder);
        this.path = builder.path;
        this.sinceId = builder.sinceId;
        this.srcPath = builder.srcPath;
        this.untilId = builder.untilId;
        this.whitespace = builder.whitespace;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    @Nullable
    public String getSinceId() {
        return this.sinceId;
    }

    @Nullable
    public String getSrcPath() {
        return this.srcPath;
    }

    @Nullable
    public String getUntilId() {
        return this.untilId;
    }

    @Nonnull
    public DiffWhitespace getWhitespace() {
        return this.whitespace;
    }

    public static class Builder
    extends AbstractPullRequestRequest.AbstractBuilder<Builder> {
        private String path;
        private String sinceId;
        private String srcPath;
        private String untilId;
        private DiffWhitespace whitespace = DiffWhitespace.SHOW;

        public Builder(@Nonnull PullRequest pullRequest) {
            this(Objects.requireNonNull(pullRequest, "pullRequest").getToRef().getRepository().getId(), pullRequest.getId());
        }

        public Builder(int repositoryId, long pullRequestId) {
            super(repositoryId, pullRequestId);
        }

        @Nonnull
        public PullRequestDiffStatsSummaryRequest build() {
            return new PullRequestDiffStatsSummaryRequest(this);
        }

        @Nonnull
        public Builder path(@Nullable String value) {
            this.path = value;
            return this.self();
        }

        @Nonnull
        public Builder sinceId(@Nullable String value) {
            this.sinceId = value;
            return this.self();
        }

        @Nonnull
        public Builder srcPath(@Nullable String value) {
            this.srcPath = StringUtils.trimToNull((String)value);
            return this.self();
        }

        @Nonnull
        public Builder untilId(@Nullable String value) {
            this.untilId = value;
            return this.self();
        }

        @Nonnull
        public Builder whitespace(@Nonnull DiffWhitespace value) {
            this.whitespace = Objects.requireNonNull(value, "whitespace");
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

