/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.migration;

import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class MeshMigrationRequest {
    public static final long MIN_BYTES_PER_SECOND = 131072L;
    private final boolean all;
    private final long maxBytesPerSecond;
    private final Set<Integer> projectIds;
    private final Set<Integer> repositoryIds;

    private MeshMigrationRequest(@Nonnull Builder builder) {
        this.all = builder.all;
        this.maxBytesPerSecond = builder.maxBytesPerSecond;
        this.projectIds = builder.projectIds.build();
        this.repositoryIds = builder.repositoryIds.build();
    }

    @Deprecated
    public long getMaxBytesPerSecond() {
        return this.maxBytesPerSecond;
    }

    @Nonnull
    public Set<Integer> getProjectIds() {
        return this.projectIds;
    }

    @Nonnull
    public Set<Integer> getRepositoryIds() {
        return this.repositoryIds;
    }

    public boolean isAll() {
        return this.all;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<Integer> projectIds;
        private final ImmutableSet.Builder<Integer> repositoryIds;
        private boolean all;
        private long maxBytesPerSecond = Long.MAX_VALUE;

        public Builder() {
            this.projectIds = new ImmutableSet.Builder();
            this.repositoryIds = new ImmutableSet.Builder();
        }

        @Nonnull
        public Builder all(boolean value) {
            this.all = value;
            return this;
        }

        @Nonnull
        public MeshMigrationRequest build() {
            return new MeshMigrationRequest(this);
        }

        @Deprecated
        @Nonnull
        public Builder maxBytesPerSecond(long value) {
            Preconditions.checkArgument((value > 131072L ? 1 : 0) != 0, (Object)"maxBytesPerSecond must be at least 131072");
            this.maxBytesPerSecond = value;
            return this;
        }

        @Nonnull
        public Builder projectId(int value) {
            this.projectIds.add((Object)value);
            return this;
        }

        @Nonnull
        public Builder projectIds(@Nonnull Iterable<Integer> values) {
            Builder.addIf(Objects::nonNull, this.projectIds, values);
            return this;
        }

        @Nonnull
        public Builder repositoryId(int value) {
            this.repositoryIds.add((Object)value);
            return this;
        }

        @Nonnull
        public Builder repositoryIds(@Nonnull Iterable<Integer> values) {
            Builder.addIf(Objects::nonNull, this.repositoryIds, values);
            return this;
        }
    }
}

