/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.event.pull;

import com.atlassian.bitbucket.event.CancelableEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.event.pull.PullRequestEvent;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.CancelState;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

@TransactionAware(value=TransactionAware.When.IMMEDIATE)
public class PullRequestOpenRequestedEvent
extends PullRequestEvent
implements CancelableEvent {
    private final CancelState cancelState;
    private final Set<ApplicationUser> reviewers;

    public PullRequestOpenRequestedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest, @Nonnull Set<ApplicationUser> reviewers, @Nonnull CancelState cancelState) {
        super(source, pullRequest, PullRequestAction.OPENED);
        this.cancelState = Objects.requireNonNull(cancelState, "cancelState");
        this.reviewers = Collections.unmodifiableSet(Objects.requireNonNull(reviewers, "reviewers"));
    }

    @Override
    public void cancel(@Nonnull KeyedMessage message) {
        this.cancelState.cancel(message);
    }

    @Nonnull
    public Set<ApplicationUser> getReviewers() {
        return this.reviewers;
    }

    @Override
    public boolean isCanceled() {
        return this.cancelState.isCanceled();
    }
}

