/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.ScmException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MergeException
extends ScmException {
    private final boolean conflicted;
    private final String from;
    private final Repository repository;
    private final String to;

    public MergeException(@Nonnull KeyedMessage message, @Nonnull String scmId, @Nonnull Repository repository, @Nonnull String from, @Nonnull String to, boolean conflicted) {
        this(message, null, scmId, repository, from, to, conflicted);
    }

    public MergeException(@Nonnull KeyedMessage message, @Nullable Throwable cause, @Nonnull String scmId, @Nonnull Repository repository, @Nonnull String from, @Nonnull String to, boolean conflicted) {
        super(message, cause, scmId);
        this.conflicted = conflicted;
        this.repository = Objects.requireNonNull(repository, "repository");
        this.from = Objects.requireNonNull(from, "from");
        this.to = Objects.requireNonNull(to, "to");
    }

    @Nonnull
    public String getFrom() {
        return this.from;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nonnull
    public String getTo() {
        return this.to;
    }

    public boolean isConflicted() {
        return this.conflicted;
    }
}

