/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.pull.RescopeDetails;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SimpleRescopeDetails
implements RescopeDetails,
Serializable {
    public static final SimpleRescopeDetails EMPTY = new SimpleRescopeDetails();
    public static final Comparator<Commit> DATE_ORDER = (lhs, rhs) -> rhs.getAuthorTimestamp().compareTo(lhs.getAuthorTimestamp());
    private final List<Commit> commits;
    private final int total;

    private SimpleRescopeDetails() {
        this.commits = Collections.emptyList();
        this.total = 0;
    }

    private SimpleRescopeDetails(Builder builder) {
        this.commits = ImmutableList.copyOf(builder.commits);
        this.total = builder.total;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleRescopeDetails that = (SimpleRescopeDetails)o;
        return Objects.equals(this.total, that.total) && Objects.equals(this.commits, that.commits);
    }

    @Override
    @Nonnull
    public List<Commit> getCommits() {
        return this.commits;
    }

    @Override
    public int getTotal() {
        return this.total;
    }

    public int hashCode() {
        return Objects.hash(this.commits, this.total);
    }

    public boolean isEmpty() {
        return this.total == 0;
    }

    public String toString() {
        return "{RescopeDetails total: " + this.total + ", commits: " + this.commits + "}";
    }

    public static class Builder
    extends BuilderSupport {
        private final List<Commit> commits;
        private int total;

        public Builder() {
            this.commits = new ArrayList<Commit>();
        }

        public Builder(@Nonnull RescopeDetails details) {
            this.commits = new ArrayList<Commit>(Objects.requireNonNull(details, "details").getCommits());
            this.total = details.getTotal();
        }

        @Nonnull
        public SimpleRescopeDetails build() {
            Collections.sort(this.commits, DATE_ORDER);
            return new SimpleRescopeDetails(this);
        }

        @Nonnull
        public Builder commit(Commit value) {
            Builder.addIf(Objects::nonNull, this.commits, value);
            return this;
        }

        @Nonnull
        public Builder commits(Iterable<Commit> value) {
            Builder.addIf(Objects::nonNull, this.commits, value);
            return this;
        }

        @Nonnull
        public Builder total(int value) {
            this.total = value;
            return this;
        }
    }
}

