/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scope;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class RepositoryScope
implements Scope {
    private final Repository repository;

    public RepositoryScope(@Nonnull Repository repository) {
        this.repository = Objects.requireNonNull(repository, "repository");
    }

    @Override
    public <T> T accept(@Nonnull ScopeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof RepositoryScope) {
            RepositoryScope that = (RepositoryScope)o;
            return Objects.equals(this.getRepository(), that.getRepository());
        }
        return false;
    }

    @Nonnull
    public Project getProject() {
        return this.repository.getProject();
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    @Nonnull
    public Optional<Integer> getResourceId() {
        return Optional.of(this.repository.getId());
    }

    @Override
    @Nonnull
    public ScopeType getType() {
        return ScopeType.REPOSITORY;
    }

    public int hashCode() {
        return Objects.hashCode(this.getRepository());
    }

    public String toString() {
        return "RepositoryScope{repository=" + this.repository.toString() + "}";
    }
}

