/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.event.repository;

import com.atlassian.bitbucket.event.repository.RepositoryEvent;
import com.atlassian.bitbucket.pull.PullRequestParticipantRequest;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.AsynchronousPreferred;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@AsynchronousPreferred
public class PullRequestFilterEvent
extends RepositoryEvent {
    private final String branch;
    private final String filterText;
    private final PullRequestState state;
    private String author;
    private String reviewer;

    public PullRequestFilterEvent(@Nonnull Object source, @Nonnull Repository repository, @Nullable PullRequestState state, @Nonnull Iterable<PullRequestParticipantRequest> prParticipants, @Nullable String branch, @Nullable String filterText) {
        super(source, repository);
        this.branch = branch;
        this.filterText = filterText;
        this.state = state;
        Objects.requireNonNull(prParticipants, "prParticipants");
        this.setAuthorAndReviewer(prParticipants);
    }

    @Nonnull
    public Optional<String> getAuthor() {
        return Optional.ofNullable(this.author);
    }

    @Nonnull
    public Optional<String> getBranch() {
        return Optional.ofNullable(this.branch);
    }

    @Nonnull
    public Optional<String> getFilterText() {
        return Optional.ofNullable(this.filterText);
    }

    @Nonnull
    public Optional<String> getReviewer() {
        return Optional.ofNullable(this.reviewer);
    }

    @Nonnull
    public Optional<PullRequestState> getState() {
        return Optional.ofNullable(this.state);
    }

    private void setAuthorAndReviewer(Iterable<PullRequestParticipantRequest> prParticipants) {
        prParticipants.forEach(participant -> {
            if (participant.getRole() == PullRequestRole.AUTHOR) {
                this.author = participant.getUsername();
            }
            if (participant.getRole() == PullRequestRole.REVIEWER) {
                this.reviewer = participant.getUsername();
            }
        });
    }
}

