package com.atlassian.bitbucket.scm.mirror;

import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import com.google.common.collect.ImmutableList;

import javax.annotation.Nonnull;
import java.util.List;
import java.util.Objects;

import static java.util.Objects.requireNonNull;

/**
 * @since 4.2
 */
public class MirrorUpdateRefsCommandParameters extends AbstractCommandParameters {

    private final List<RefChange> changes;

    private MirrorUpdateRefsCommandParameters(Builder builder) {
        changes = builder.changes.build();
    }

    /**
     * @return the {@link RefChange changes} to apply
     */
    @Nonnull
    public List<RefChange> getChanges() {
        return changes;
    }

    public static class Builder {

        private final ImmutableList.Builder<RefChange> changes;

        public Builder() {
            changes = ImmutableList.builder();
        }

        @Nonnull
        public MirrorUpdateRefsCommandParameters build() {
            return new MirrorUpdateRefsCommandParameters(this);
        }

        @Nonnull
        public Builder change(RefChange value) {
            addIf(Objects::nonNull, changes, copy(value));
            return this;
        }

        @Nonnull
        public Builder changes(@Nonnull Iterable<? extends RefChange> values) {
            requireNonNull(values, "changes").forEach(this::change);
            return this;
        }

        private static RefChange copy(RefChange value) {
            return value == null ? null : new SimpleRefChange.Builder(value).build();
        }
    }
}
