package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.InvalidNameException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Indicates the ref name supplied was syntactically incorrect.
 */
public class InvalidRefNameException extends InvalidNameException {

    private final String refName;

    public InvalidRefNameException(KeyedMessage message, String refName) {
        super(message);
        this.refName = requireNonNull(refName, "refName must be non-null");
    }

    @Nonnull
    public String getRefName() {
        return refName;
    }
}
