package com.atlassian.bitbucket.pull.reviewer;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

/**
 * @since 7.13
 */
public class NoSuchReviewerGroupException extends NoSuchEntityException {

    private final long id;

    public NoSuchReviewerGroupException(@Nonnull KeyedMessage message, long id) {
        super(message);
        this.id = id;
    }

    /**
     * @return the ID of the reviewer group that was requested
     */
    public long getId() {
        return id;
    }
}
