package com.atlassian.bitbucket.project;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;

import javax.annotation.Nonnull;

/**
 * Describes a {@link ApplicationUser user's} personal project in the system.
 * <p>
 * Each user has <i>exactly one</i> personal project, to which they always have
 * {@link Permission#PROJECT_ADMIN PROJECT_ADMIN} access. In addition to forking repositories
 * contained in other projects into their personal project, Users can also create their own private repositories there.
 * Users may grant {@link Permission permissions} on their private repositories to other users
 * to allow them to collaborate.
 * <p>
 * Personal projects are <i>fully managed by the system</i>. Their {@link #getKey() keys} and {@link #getName() names}
 * are fixed and may not be updated. Their {@link ProjectService#getAvatar(int, int) avatars} are drawn from their
 * {@link #getOwner() owning users} and cannot be changed directly. Personal projects cannot be deleted, even if they
 * contain no {@link Repository repositories}.
 */
public interface PersonalProject extends Project {

    /**
     * Retrieves the {@link ApplicationUser user} to whom this personal project belongs.
     *
     * @return the personal project's owner
     */
    @Nonnull
    ApplicationUser getOwner();
}
