package com.atlassian.bitbucket.io;

import javax.annotation.Nonnull;
import java.io.IOException;
import java.io.OutputStream;

/**
 * Supplies an {@code OutputStream} after receiving the content type for the data that will be streamed to it.
 */
@FunctionalInterface
public interface TypeAwareOutputSupplier {

    /**
     * Returns an {@code OutputStream}, given the supplied content type. This gives the implementation a chance to act
     * on the content type, perhaps setting HTTP headers or preparing to validate the streamed data.
     *
     * @param contentType the content type for the data that will be written to the stream
     * @return a stream the caller can write content to
     * @throws IOException if a stream cannot be provided
     */
    @Nonnull
    OutputStream getStream(@Nonnull String contentType) throws IOException;
}
