package com.atlassian.bitbucket.hook.script;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * A generic base class for exceptions to be thrown when {@link HookScriptService} operations fail.
 *
 * @since 6.2
 */
public class HookScriptException extends ServiceException {

    public HookScriptException(@Nonnull KeyedMessage message) {
        super(message);
    }

    public HookScriptException(@Nonnull KeyedMessage message, @Nullable Throwable cause) {
        super(message, cause);
    }
}
