package com.atlassian.bitbucket.event.tag;

import com.atlassian.bitbucket.hook.repository.AbstractRepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookTrigger;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.Tag;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * @since 5.0
 */
public abstract class TagHookRequest extends AbstractRepositoryHookRequest {

    private final Tag tag;

    protected TagHookRequest(AbstractBuilder<?> builder) {
        super(builder);

        tag = builder.tag;
    }

    @Nonnull
    public Tag getTag() {
        return tag;
    }

    protected abstract static class AbstractBuilder<B extends AbstractBuilder<B>>
            extends AbstractRepositoryHookRequest.AbstractBuilder<B> {

        private final Tag tag;

        protected AbstractBuilder(@Nonnull Repository repository, @Nonnull RepositoryHookTrigger trigger,
                                  @Nonnull Tag tag) {
            super(repository, trigger);

            this.tag = requireNonNull(tag, "tag");
        }
    }
}
