package com.atlassian.bitbucket.event.tag;

import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.StandardRepositoryHookTrigger;
import com.atlassian.bitbucket.repository.*;
import org.apache.commons.lang3.StringUtils;

import javax.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;

/**
 * A {@link RepositoryHookRequest hook request} that is raised just before a tag is created using the UI or REST.
 * Tags created by pushing will trigger a standard {@link RepositoryHookRequest} and not this specific type.
 *
 * @see StandardRepositoryHookTrigger#TAG_CREATE
 * @since 5.0
 */
public class TagCreationHookRequest extends TagHookRequest {

    private final Collection<RefChange> changes;

    private TagCreationHookRequest(Builder builder) {
        super(builder);

        changes = Collections.singleton(new SimpleRefChange.Builder()
                .fromHash(StringUtils.repeat("0", 40))
                .to(getTag())
                .type(RefChangeType.ADD)
                .build());
    }

    @Nonnull
    @Override
    public Collection<RefChange> getRefChanges() {
        return changes;
    }

    public static class Builder extends AbstractBuilder<Builder> {

        public Builder(@Nonnull Repository repository, @Nonnull Tag tag) {
            super(repository, StandardRepositoryHookTrigger.TAG_CREATE, tag);
        }

        @Nonnull
        public TagCreationHookRequest build() {
            return new TagCreationHookRequest(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
