package com.atlassian.bitbucket.event.request;

import com.atlassian.bitbucket.request.RequestContext;

import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import java.util.EventObject;

import static java.util.Objects.requireNonNull;

/**
 * A base class for constructing events related to requests (i.e. HTTP and SSH requests).
 */
public abstract class RequestEvent extends EventObject {

    private final boolean http;
    private final RequestContext requestContext;

    protected RequestEvent(@Nonnull Object source, @Nonnull RequestContext requestContext) {
        super(source);

        this.requestContext = requireNonNull(requestContext, "requestContext");

        http = requestContext.getRawRequest() instanceof HttpServletRequest;
    }

    /**
     * Retrieves the {@code RequestContext} for the event.
     *
     * @return the request
     */
    @Nonnull
    public RequestContext getRequestContext() {
        return requestContext;
    }

    /**
     * Retrieves a flag indicating whether the event's request, available from the {@link #getRequestContext() request
     * context}, is an {@code HttpServletRequest}.
     *
     * @return {@code true} if the request is an {@code HttpServletRequest}; otherwise, {@code false}
     */
    public boolean isHttp() {
        return http;
    }
}
