package com.atlassian.bitbucket.event.request;

import com.atlassian.bitbucket.request.RequestContext;

/**
 * Dispatched to indicate a requestContext has ended.
 */
public class RequestEndedEvent extends RequestEvent {

    /**
     * Constructs a new {@code RequestEndedEvent}, providing the event's source and the RequestContext for the
     * request that was ended.
     *
     * @param source  the event source
     * @param requestContext the RequestContext for the ended request
     */
    public RequestEndedEvent(Object source, RequestContext requestContext) {
        super(source, requestContext);
    }
}
