package com.atlassian.bitbucket.event.repository;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Event that is raised when a repository is created.
 * <p>
 * This event is internally audited with {@link CoverageLevel#BASE} level.
 */
@AsynchronousPreferred
@TransactionAware
@EventName("stash.repository.created")
public class RepositoryCreatedEvent extends RepositoryEvent {

    public RepositoryCreatedEvent(@Nonnull Object source, @Nonnull Repository repository) {
        super(source, repository);
    }
}
