package com.atlassian.bitbucket.event.pull;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Event raised when a {@link PullRequestParticipant participant} updates its status
 * on a {@link PullRequest pull request} to {@link PullRequestParticipantStatus#UNAPPROVED}
 */
@AsynchronousPreferred
@EventName("stash.pullrequest.unapproved")
public class PullRequestParticipantUnapprovedEvent extends PullRequestParticipantStatusUpdatedEvent {

    public PullRequestParticipantUnapprovedEvent(@Nonnull Object source,
                                                 @Nonnull PullRequest pullRequest,
                                                 @Nonnull PullRequestParticipant participant,
                                                 @Nonnull PullRequestParticipantStatus previous) {
        super(source, pullRequest, PullRequestAction.UNAPPROVED, participant, previous);
    }
}
