package com.atlassian.bitbucket.event.pull;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Event that is raised when a pull request is declined.
 */
@AsynchronousPreferred
@EventName("stash.pullrequest.declined")
public class PullRequestDeclinedEvent extends PullRequestEvent {

    public PullRequestDeclinedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest) {
        super(source, pullRequest, PullRequestAction.DECLINED);
    }
}
