package com.atlassian.bitbucket.event.hook;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Fired when a repository hook is enabled
 */
@AsynchronousPreferred
@TransactionAware
@EventName("stash.repository.hook.enabled")
public class RepositoryHookEnabledEvent extends RepositoryHookEvent {

    /**
     * @param source            the object on which the event initially occurred
     * @param repositoryHookKey the key of the repository hook
     * @param scope             scope that the hook event was created for
     * @since 5.2
     */
    public RepositoryHookEnabledEvent(@Nonnull Object source, @Nonnull Scope scope, @Nonnull String repositoryHookKey) {
        super(source, repositoryHookKey, scope);
    }
}
