package com.atlassian.bitbucket.event.cluster;

import com.atlassian.bitbucket.cluster.ClusterInformation;
import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;
import java.util.Set;

/**
 * Raised when an {@link #getRemovedNode() existing node} leaves the cluster.
 * <p>
 * Due to the non-deterministic nature of event processing, it is possible the other nodes may have joined or left the
 * cluster. As a result, using the {@link ClusterInformation#getNodes() ClusterInformation}
 * to determine the cluster nodes may be inconsistent. {@link #getCurrentNodes()} is provided to simplify deterministic
 * processing in listeners.
 */
@AsynchronousPreferred
public class ClusterNodeRemovedEvent extends ClusterMembershipEvent {

    public ClusterNodeRemovedEvent(@Nonnull Object source, @Nonnull ClusterNode node,
                                   @Nonnull Set<ClusterNode> currentNodes) {
        super(source, node, currentNodes);
    }

    /**
     * @return the removed node, which <i>will not</i> be in the {@link #getCurrentNodes() current nodes} set
     */
    @Nonnull
    public ClusterNode getRemovedNode() {
        return getNode();
    }
}
