package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.comment.CommentThread;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.io.IOException;
import java.util.stream.Stream;

/**
 * Convenience implementation of {@link DiffContentCallback} that provides no-op implementations for all methods.
 */
public abstract class AbstractDiffContentCallback implements DiffContentCallback {

    /**
     * @param threads a stream of zero or more threads describing comments within the diff or diffs that will be
     *                streamed to the callback. It can only be consumed once
     * @since 5.0
     */
    @Override
    public void offerThreads(@Nonnull Stream<CommentThread> threads) throws IOException {
    }

    @Override
    public void onBinary(@Nullable Path src, @Nullable Path dst) throws IOException {
    }

    @Override
    public void onDiffEnd(boolean truncated) throws IOException {
    }

    @Override
    public void onDiffStart(@Nullable Path src, @Nullable Path dst) throws IOException {
    }

    /**
     * @param summary ignored
     * @throws IOException may be thrown by derived classes
     */
    @Override
    public void onEnd(@Nonnull DiffSummary summary) throws IOException {
    }

    @Override
    public void onHunkEnd(boolean truncated) throws IOException {
    }

    /**
     * @param srcLine the line in the source file at which the hunk starts
     * @param srcSpan the number of lines spanned by this hunk in the source file
     * @param dstLine the line in the destination file at which the hunk starts
     * @param dstSpan the number of lines spanned by this hunk in the destination file
     * @param context an optional context, such as a method or class name, for the hunk's lines
     * @throws IOException may be thrown by derived classes
     * @since 5.5
     */
    @Override
    public void onHunkStart(int srcLine, int srcSpan, int dstLine, int dstSpan, @Nullable String context)
            throws IOException {
    }

    @Override
    public void onSegmentEnd(boolean truncated) throws IOException {
    }

    @Override
    public void onSegmentLine(@Nonnull String line, @Nullable ConflictMarker marker, boolean truncated)
            throws IOException {
    }

    @Override
    public void onSegmentStart(@Nonnull DiffSegmentType type) throws IOException {
    }

    /**
     * @param context ignored
     * @throws IOException may be thrown by derived classes
     */
    @Override
    public void onStart(@Nonnull DiffContext context) throws IOException {
    }
}
