package com.atlassian.bitbucket.comment;

import javax.annotation.Nonnull;
import java.util.Date;
import java.util.Optional;

/**
 * Represents a conversation started on a {@link Commentable commentable}. The comment thread knows about the
 * commentable {@link #getCommentable() commentable}, all the comments in the conversation (accessible through the
 * {@link #getRootComment() root comment}) and (optionally) where the thread is {@link #getAnchor() anchored} on a diff.
 *
 * @since 5.0
 */
public interface CommentThread {

    /**
     * @return the anchor for comment threads created on a diff.
     */
    @Nonnull
    Optional<CommentThreadDiffAnchor> getAnchor();

    /**
     * @return the commentable on which this comment thread is anchored.
     */
    @Nonnull
    Commentable getCommentable();

    /**
     * @return the date on which this comment thread was created.
     */
    @Nonnull
    Date getCreatedDate();

    /**
     * @return the comment thread's ID.
     */
    long getId();

    /**
     * @return the root comment in the thread.
     */
    @Nonnull
    Comment getRootComment();

    /**
     * @return the date on which the latest comment was added to this thread.
     */
    @Nonnull
    Date getUpdatedDate();

    /**
     * @return {@code true} if the {@link #getAnchor() anchor} is present, otherwise {@code false}
     */
    boolean isAnchored();

    /**
     * @return {@code true} if the thread is resolved, otherwise {@code false}
     *
     * @since 8.9
     */
    boolean isResolved();
}
