/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.permission;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.ApplicationUser;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PermissionRequest {
    private final Permission permission;
    private final Object resource;
    private final ApplicationUser user;

    protected PermissionRequest(Builder builder) {
        this.permission = builder.permission;
        this.resource = builder.resource;
        this.user = builder.user;
    }

    @Nonnull
    public Permission getPermission() {
        return this.permission;
    }

    @Nullable
    public Object getResource() {
        return this.resource;
    }

    @Nullable
    public <T> T getResourceAs(@Nonnull Class<T> resourceType) {
        return Objects.requireNonNull(resourceType, "resourceType").cast(this.resource);
    }

    @Nullable
    public ApplicationUser getUser() {
        return this.user;
    }

    public static class Builder {
        private final Permission permission;
        private Object resource;
        private ApplicationUser user;

        public Builder(@Nonnull Permission permission) {
            this.permission = Objects.requireNonNull(permission, "permission");
        }

        public Builder(@Nonnull PermissionRequest request) {
            this.permission = request.permission;
            this.resource = request.resource;
            this.user = request.user;
        }

        @Nonnull
        public PermissionRequest build() {
            return new PermissionRequest(this);
        }

        @Nonnull
        public Builder resource(@Nullable Object value) {
            this.resource = value;
            return this;
        }

        @Nonnull
        public Builder user(@Nullable ApplicationUser value) {
            this.user = value;
            return this;
        }
    }
}

