/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hook.repository;

import com.atlassian.bitbucket.hook.repository.AbstractRepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.MergeHookRequest;
import com.atlassian.bitbucket.hook.repository.StandardRepositoryHookTrigger;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryRef;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimpleMergeHookRequest
extends AbstractRepositoryHookRequest
implements MergeHookRequest {
    private final RepositoryRef fromRef;
    private final String mergeHash;
    private final String message;
    private final List<RefChange> refChanges;
    private final String strategyId;
    private final RepositoryRef toRef;

    private SimpleMergeHookRequest(Builder builder) {
        super(builder);
        this.fromRef = Objects.requireNonNull(builder.fromRef, "fromRef");
        this.toRef = Objects.requireNonNull(builder.toRef, "toRef");
        this.mergeHash = builder.mergeHash;
        this.message = builder.message;
        this.strategyId = builder.strategyId;
        this.refChanges = this.mergeHash == null ? Collections.emptyList() : Collections.singletonList(((SimpleRefChange.Builder)((SimpleRefChange.Builder)((SimpleRefChange.Builder)new SimpleRefChange.Builder().from(this.toRef)).toHash(this.mergeHash)).type(RefChangeType.UPDATE)).build());
    }

    @Override
    @Nonnull
    public RepositoryRef getFromRef() {
        return this.fromRef;
    }

    @Override
    @Nonnull
    public Optional<String> getMergeHash() {
        return Optional.ofNullable(this.mergeHash);
    }

    @Override
    @Nonnull
    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    @Override
    @Nonnull
    public Collection<RefChange> getRefChanges() {
        return this.refChanges;
    }

    @Override
    @Nonnull
    public Optional<String> getStrategyId() {
        return Optional.ofNullable(this.strategyId);
    }

    @Override
    @Nonnull
    public RepositoryRef getToRef() {
        return this.toRef;
    }

    @Override
    public boolean isCrossRepository() {
        return !Objects.equals(this.fromRef.getRepository(), this.toRef.getRepository());
    }

    public static class Builder
    extends AbstractRepositoryHookRequest.AbstractBuilder<Builder> {
        private RepositoryRef fromRef;
        private String mergeHash;
        private String message;
        private String strategyId;
        private RepositoryRef toRef;

        public Builder(@Nonnull Repository repository) {
            super(repository, StandardRepositoryHookTrigger.MERGE);
        }

        @Nonnull
        public SimpleMergeHookRequest build() {
            return new SimpleMergeHookRequest(this);
        }

        @Nonnull
        public Builder fromRef(@Nonnull RepositoryRef value) {
            this.fromRef = Objects.requireNonNull(value, "fromRef");
            return this.self();
        }

        @Nonnull
        public Builder mergeHash(@Nullable String value) {
            this.mergeHash = value;
            return this.self();
        }

        @Nonnull
        public Builder message(@Nullable String value) {
            this.message = value;
            return this.self();
        }

        @Nonnull
        public Builder strategyId(@Nullable String value) {
            this.strategyId = value;
            return this.self();
        }

        @Nonnull
        public Builder toRef(@Nonnull RepositoryRef value) {
            this.toRef = Objects.requireNonNull(value, "toRef");
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

