package com.atlassian.bitbucket.zdu;

import com.atlassian.bitbucket.IllegalEntityStateException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

/**
 * While trying to enter or exit upgrade mode, this exception is thrown to signal that operation is not allowed because
 * of current state of system e.g. when cluster nodes are not on same build version.
 *
 * @since 8.0
 */
public class IllegalRollingUpgradeStateException extends IllegalEntityStateException {

    public IllegalRollingUpgradeStateException(@Nonnull KeyedMessage message) {
        super(message);
    }
}
