package com.atlassian.bitbucket.validation.annotation;

import com.atlassian.bitbucket.validation.OptionalStringValidator;
import org.hibernate.validator.constraints.Length;

import javax.validation.Constraint;
import javax.validation.OverridesAttribute;
import javax.validation.Payload;
import javax.validation.ReportAsSingleViolation;
import java.lang.annotation.*;

/**
 * Optional but if it is supplied it must be no longer than max characters and must not be the empty string (0-length).
 */
@Constraint(validatedBy = { OptionalStringValidator.class })
@Documented
@Length
@ReportAsSingleViolation
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.FIELD})
public @interface OptionalString {

    Class<?>[] groups() default {};

    String message() default "{com.atlassian.bitbucket.validation.optional.string.message}";

    @OverridesAttribute(constraint = Length.class, name = "min")
    int minimumSize() default 1;

    Class<? extends Payload>[] payload() default {};

    @OverridesAttribute(constraint = Length.class, name = "max")
    int size() default 255;
}
