package com.atlassian.bitbucket.validation.annotation;

import com.atlassian.bitbucket.validation.FieldEqualsValidator;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.*;

/**
 * Validate that multiple fields on an object have identical values.
 */
@Constraint(validatedBy = {FieldEqualsValidator.class})
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE})
public @interface FieldEquals {

    String message() default "";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};

    /** @return fields to test for equality */
    String[] fields() default {};

    /** @return field on which the violation will be reported */
    String reportingField() default "";

}
