package com.atlassian.bitbucket.server;

import javax.annotation.Nonnull;
import java.nio.file.Path;

/**
 * Allows apps to interact with selected parts of the product's home directory.
 *
 * @since 5.11
 */
public interface StorageService {

    /**
     * @return the {@link #getHomeDir home} subdirectory where cache data should be stored
     */
    @Nonnull
    Path getCacheDir();

    /**
     * @return the {@link #getSharedHomeDir shared home} subdirectory where configuration data should be stored
     */
    @Nonnull
    Path getConfigDir();

    /**
     * @return the {@link #getSharedHomeDir shared home} subdirectory where app data should be stored
     */
    @Nonnull
    Path getDataDir();

    /**
     * @return the product's home directory, which is <i>node local</i> in Data Center installations
     */
    @Nonnull
    Path getHomeDir();

    /**
     * @return the product's shared home directory, which is available to <i>all nodes</i> in a Data Center installation
     */
    @Nonnull
    Path getSharedHomeDir();

    /**
     * @return the {@link #getHomeDir home} subdirectory where short-lived temporary data should be stored
     */
    @Nonnull
    Path getTempDir();
}
