package com.atlassian.bitbucket.scm.pull;

import com.atlassian.bitbucket.content.DiffContext;
import com.atlassian.bitbucket.scm.AbstractDiffCommandParameters;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

public class PullRequestDiffCommandParameters extends AbstractDiffCommandParameters {

    private PullRequestDiffCommandParameters(Builder builder) {
        super(builder);
    }

    /**
     * Assembles a {@link DiffContext} from these parameters using the hashes from the {@link PullRequestEffectiveDiff
     * current effective diff}.
     *
     * @param effectiveDiff the current {@link PullRequestEffectiveDiff effective diff} for the pull request
     * @return a {@link DiffContext} describing these parameters
     */
    @Nonnull
    public DiffContext toContext(@Nonnull PullRequestEffectiveDiff effectiveDiff) {
        requireNonNull(effectiveDiff, "effectiveDiff");

        return toContext(new DiffContext.Builder(effectiveDiff.getSinceId(), effectiveDiff.getUntilId()));
    }

    public static class Builder extends AbstractBuilder<Builder> {

        public Builder() {
        }

        @Nonnull
        public PullRequestDiffCommandParameters build() {
            return new PullRequestDiffCommandParameters(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
